<?php
// filepath: d:\laragon\www\tani-api\config.php
class Config
{
    private static $config = null;

    public static function load()
    {
        if (self::$config === null) {
            self::$config = [];

            // Load .env file if exists
            $envFile = __DIR__ . '/.env';
            if (file_exists($envFile)) {
                $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                foreach ($lines as $line) {
                    if (strpos(trim($line), '#') === 0) continue; // Skip comments

                    list($key, $value) = explode('=', $line, 2);
                    $key = trim($key);
                    $value = trim($value);

                    // Remove quotes if present
                    if (preg_match('/^["\'](.*)["\']/s', $value, $matches)) {
                        $value = $matches[1];
                    }

                    self::$config[$key] = $value;
                }
            }

            // Fallback to $_ENV and getenv()
            foreach ($_ENV as $key => $value) {
                if (!isset(self::$config[$key])) {
                    self::$config[$key] = $value;
                }
            }
        }
    }

    public static function get($key, $default = null)
    {
        self::load();
        return isset(self::$config[$key]) ? self::$config[$key] : $default;
    }
}
