<?php
// filepath: d:\laragon\www\tani-api\database.php
require_once __DIR__ . '/config.php';

// Konfigurasi koneksi MySQL dari environment
$host = Config::get('DB_HOST');
$user = Config::get('DB_USER');
$pass = Config::get('DB_PASS');
$db   = Config::get('DB_NAME');

ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/api_debug.log');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
    $conn = new mysqli($host, $user, $pass, $db);
    $conn->set_charset('utf8mb4');
    error_log("✅ [DB] Database connection successful");
} catch (mysqli_sql_exception $e) {
    error_log("❌ [DB] Database connection failed: " . $e->getMessage());
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}
