<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Enable error logging
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/api_debug.log');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/database.php';

// Function untuk response yang konsisten
function sendResponse($status, $message, $data = null, $httpCode = 200, $errorCode = null)
{
    error_log("📤 [USERS] Sending response: Status=$status, Code=$httpCode, Message=$message");

    http_response_code($httpCode);
    $response = [
        "status" => $status,
        "message" => $message,
        "timestamp" => date('Y-m-d H:i:s')
    ];

    if ($data !== null) {
        $response["data"] = $data;
    }

    if ($errorCode !== null) {
        $response["error_code"] = $errorCode;
    }

    echo json_encode($response);
    exit;
}

// GET - Read all users
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    try {
        error_log("📋 [USERS] Getting all users");

        $sql = "SELECT id, nama, email, tanggal_dibuat 
                FROM users 
                ORDER BY tanggal_dibuat DESC";

        $result = $conn->query($sql);

        if (!$result) {
            error_log("❌ [USERS] Query failed: " . $conn->error);
            sendResponse("error", "Database error", null, 500, "DATABASE_ERROR");
        }

        $users = [];
        while ($row = $result->fetch_assoc()) {
            $users[] = [
                "id" => (int)$row['id'],
                "nama" => $row['nama'],
                "email" => $row['email'],
                "tanggal_dibuat" => $row['tanggal_dibuat']
            ];
        }

        error_log("✅ [USERS] Found " . count($users) . " users");

        sendResponse("success", "Data users berhasil diambil", [
            "users" => $users,
            "total_records" => count($users)
        ]);
    } catch (Exception $e) {
        error_log("💥 [USERS] GET Exception: " . $e->getMessage());
        sendResponse("error", "Terjadi kesalahan sistem", null, 500, "SYSTEM_ERROR");
    }
}

// Method not allowed
error_log("❌ [USERS] Method not allowed: " . $_SERVER['REQUEST_METHOD']);
sendResponse("error", "Method tidak didukung. Gunakan GET", null, 405, "METHOD_NOT_ALLOWED");
